/* 
DATE: August 23, 2009
PURPOSE: Strip merged ADAMS cognition set down to needed variables with better names
TAKES IN: ADAMS_Cognitive_Measures_(raw)
PUTS OUT: ADAMS_Cognitive_Measures_(polished)
*/

// SETTINGS:
local log_p = "true"
local latex_p = "false"
local reset_p = "true"

// RESET:
if "`reset_p'" == "true" {
	clear
	set mem 100m
	// set maxvar 7000
}

// NAMES:
local dir "/Users/Bowen/Documents/Laibson/HRS/Cognition Files/"
local lfilename = "ADAMS Polish Log" // log name
local tfilename "" // tex name
local usefile "ADAMS_Cognitive_Measures_(raw)"

// PRELIMINARIES:
set more off
local time_now = substr(c(current_date),4,3) + substr(c(current_date),1,2) + " | " + subinstr(substr(c(current_time),1,5),":","-",1)
timer clear
timer on 47

// LOG:
if "`log_p'" == "true" {
	capture log close
	set logtype text
	log using "`dir'Logs/`lfilename' (`time_now').txt", replace
}

// LATEX:
if "`latex_p'" == "true" {
	capture: erase "`dir'`tfilename'.tex"
	capture file close tfile
	file open tfile using "`dir'`tfilename'.tex", write replace
	#delimit ;
	file write tfile 
		"\documentclass[11pt]{article}" _n
		"\usepackage{graphicx}" _n(2)
		"\begin{document}" _n(2)
		"\title{}" _n 
		"\author{Kyle Chauvin}" _n 
		"\maketitle" _n(2)
		"\newpage" _n(2); 	
	#delimit cr
}

//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
//\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\ 

use "`dir'`usefile'"

local keep_vars "hhid pn Acwave"

// Dates:

gen intdate1 = mdy(Aamonth, 1, Aayear)
gen intdate2 = mdy(Acmonth, 1, Acyear)

local keep_vars "`keep_vars' intdate1 intdate2"

// CDR:

forvalues n = 1 / 2 {
	rename Adcdrstg`n' cdr`n'
	replace cdr`n' = . if cdr`n' > 50
}

local keep_vars "`keep_vars' cdr1 cdr2 Aaasampwt_f Aaclongwt"

keep `keep_vars'
save "`dir'ADAMS_Cognitive_Measures_(polished)", replace

////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////

if "`latex_p'" == "true" {
	file write tfile "\end{document}" _n
	file close tfile
	shell latex "`dir'`tfilename'.tex" "`dir'../"

	***Erasing unnecessary files
	foreach extension in "aux" "log" {
		capture: erase "`dir'`tfilename'.`extension'"
	}
}

timer off 47
timer list 47
capture log close

exit

/* forvalues x = 1 / 11 {
	local x_1 = `x' + 1
	forvalues y = `x_1' / 11 {
		egen same`x'_`y' = diff(E1174M`x' E1174M`y')
		replace same`x'_`y' = . if E1174M`x' == .
		replace same`x'_`y' = 3 if same`x'_`y' == 0
		replace same`x'_`y' = 0 if same`x'_`y' == 1
		replace same`x'_`y' = 1 if same`x'_`y' == 3
	}
}

egen total_same = rowtotal(same*)

tab total_same */